@addField(ScriptedPuppet)
let preventionHeatStage: EPreventionHeatStage;

@replaceMethod(PreventionSystem)
  private final func OnRegisterUnit(request: ref<RegisterUnitRequest>) -> Void {
    let i: Int32;
    if !IsDefined(request.unit) || NotEquals(request.unit.GetNPCType(), gamedataNPCType.Human) {
      return;
    };
	request.unit.preventionHeatStage = this.m_heatStage;
    i = ArraySize(this.m_vehicles) - 1;
    while i >= 0 {
      if !this.MountVehicle(request.unit, this.m_vehicles[i]) {
        ArrayErase(this.m_vehicles, i);
      } else {
        break;
      };
      i -= 1;
    };
  }
  
@addMethod(PreventionSystem)
private final func DespawnFarAwayOrDeadPolice(){
	let i: Int32 = ArraySize(this.m_spawnedAgents) - 1;
	let heat1Despawn: Bool = true;
	let heat2Despawn: Bool = true;
	let heat3Despawn: Bool = true;
	let heat4Despawn: Bool = true;
	while i>=0{
		if Vector4.Distance(this.m_player.GetWorldPosition(), this.m_spawnedAgents[i].GetWorldPosition()) < 150.0 && !this.m_spawnedAgents[i].IsDead() && !ScriptedPuppet.IsDefeated(this.m_spawnedAgents[i]){
			if Equals(this.m_spawnedAgents[i].preventionHeatStage, EPreventionHeatStage.Heat_1){
				heat1Despawn = false;
			};	
			if Equals(this.m_spawnedAgents[i].preventionHeatStage, EPreventionHeatStage.Heat_2){
				heat2Despawn = false;
			};	
			if Equals(this.m_spawnedAgents[i].preventionHeatStage, EPreventionHeatStage.Heat_3){
				heat3Despawn = false;
			};	
			if Equals(this.m_spawnedAgents[i].preventionHeatStage, EPreventionHeatStage.Heat_4){
				heat4Despawn = false;
			};	
		};
		i = i - 1;
	};
	if heat1Despawn{
      GameInstance.GetPreventionSpawnSystem(this.GetGameInstance()).RequestDespawnPreventionLevel(Cast(1));
	};
	if heat2Despawn{
      GameInstance.GetPreventionSpawnSystem(this.GetGameInstance()).RequestDespawnPreventionLevel(Cast(2));
	};
	if heat3Despawn{
      GameInstance.GetPreventionSpawnSystem(this.GetGameInstance()).RequestDespawnPreventionLevel(Cast(3));
	};
	if heat4Despawn{
      GameInstance.GetPreventionSpawnSystem(this.GetGameInstance()).RequestDespawnPreventionLevel(Cast(4));
	};	
}

@replaceMethod(PreventionSystem) //Only despawns when not in combat
  private final func DespawnAllPolice() -> Void {
	return;
	//this.DespawnFarAwayOrDeadPolice(); Come back to this later
	
	if this.m_player.IsInCombat() { //if player in combat, don't get rid of these bad boys
		return;
	};

    let i: Int32 = 0;
    while i <= EnumInt(EPreventionHeatStage.Size) {
      GameInstance.GetPreventionSpawnSystem(this.GetGameInstance()).RequestDespawnPreventionLevel(Cast(i));
      i += 1;
    };
}
